<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use App\Http\Middleware\LocaleMiddleware;

return Application::configure(basePath: dirname(__DIR__))
  ->withRouting(
    web: __DIR__ . '/../routes/web.php',
    commands: __DIR__ . '/../routes/console.php',
    health: '/up',
  )
  ->withMiddleware(function (Middleware $middleware) {
    $middleware->alias([
      'auth-wali' => \App\Http\Middleware\CekWaliSantri::class,
      'auth-guru' => \App\Http\Middleware\CekGuru::class,
      'auth-admin' => \App\Http\Middleware\CekAdmin::class,
      'auth' => \App\Http\Middleware\CekLogin::class,
    ]);
  })
  ->withExceptions(function (Exceptions $exceptions) {
    //
  })->create();
