<!DOCTYPE html>
<html>
<head>
    <title>Advanced Background Changer</title>
    <style>
        .preview-container {
            display: flex;
            gap: 20px;
            margin-top: 20px;
        }
        .preview-box {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
        }
    </style>
</head>
<body>
    <h1>Advanced Background Changer</h1>
    <form action="process.php" method="post" enctype="multipart/form-data" id="uploadForm">
        <div>
            <label for="photo">Upload Foto:</label>
            <input type="file" name="photo" id="photo" accept="image/*" required>
        </div>
        
        <div>
            <label for="background">Pilih Background:</label>
            <select name="background" id="background">
                <option value="office.jpg">Background Kantor</option>
                <option value="beach.jpg">Background Pantai</option>
                <option value="nature.jpg">Background Alam</option>
            </select>
        </div>
        
        <button type="submit">Proses Foto</button>
    </form>

    <div class="preview-container">
        <div class="preview-box">
            <h3>Foto Asli</h3>
            <img id="previewOriginal" style="max-width: 300px; display: none;">
        </div>
        <div class="preview-box">
            <h3>Hasil</h3>
            <img id="previewResult" style="max-width: 300px; display: none;">
        </div>
    </div>

    <script>
        // Preview image sebelum upload
        document.getElementById('photo').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(event) {
                    document.getElementById('previewOriginal').src = event.target.result;
                    document.getElementById('previewOriginal').style.display = 'block';
                    document.getElementById('previewResult').style.display = 'none';
                };
                reader.readAsDataURL(file);
            }
        });
    </script>
</body>
</html>