<?php
require('fpdf/fpdf.php');
require('lib/BarcodeGenerator/BarcodeGenerator.php');
require('lib/BarcodeGenerator/BarcodeGeneratorPNG.php');

use Picqer\Barcode\BarcodeGeneratorPNG;

// Data santri dummy
$data_santri = [
    [
        'id_santri' => 'S1001',
        'nama' => 'Ahmad Fauzi',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Kediri, 01-01-2010',
        'alamat' => 'Ds. Sumberjo',
        'tahun_masuk' => '2022',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    [
        'id_santri' => 'S1002',
        'nama' => 'M. Zaki',
        'jenis_kelamin' => 'Laki-laki',
        'ttl' => 'Nganjuk, 02-02-2011',
        'alamat' => 'Ds. Tiru Kidul, Kec. Gurah, Kab. Kediri raya, jatim',
        'tahun_masuk' => '2023',
        'foto' => 'assets/foto/S123456.jpg'
    ],
    // Tambah data lain sesuai kebutuhan
];

$pdf = new FPDF('P', 'mm', 'A4');
$pdf->SetAutoPageBreak(false);

$generator = new BarcodeGeneratorPNG();
$background = 'desain_kartu.png';

$kartu_width = 86;
$kartu_height = 54;
$margin_x = 10;
$margin_y = 10;
$space_x = 0.5;
$space_y = 0.1;
$col = 0;
$row = 0;

foreach ($data_santri as $index => $data) {
    if ($index % 10 == 0) {
        $pdf->AddPage();
        $col = 0;
        $row = 0;
    }

    $x = $margin_x + ($col * ($kartu_width + $space_x));
    $y = $margin_y + ($row * ($kartu_height + $space_y));

    // Background kartu
    $pdf->Image($background, $x, $y, $kartu_width, $kartu_height);

    // Foto (diletakkan di kiri bawah, tidak menutupi logo)
    if (file_exists($data['foto'])) {
        $pdf->Image($data['foto'], $x + 4, $y + 20, 19.5, 26); // ukuran (rasio 3x4) & posisi disesuaikan
    }

                // Pengaturan posisi dan jarak baris
                $p_x = 28;
                $p_y = 18;
                $line_spacing = 4; // tinggi baris (tapi untuk MultiCell tinggi baris pakai parameter 3 misalnya)

                // Lebar area teks agar tidak keluar desain
                $text_width = 55; // sesuaikan dengan desain kartu

                // Nama (font ukuran 10, bold)
                $nama_font_size = 10;
                $nama_font_style = 'B';
                $pdf->SetFont('Arial', $nama_font_style, $nama_font_size);
                $pdf->SetXY($x + $p_x, $y + $p_y);
                $pdf->Cell($text_width, 4, $data['nama'], 0, 1); // pakai Cell karena biasanya nama tidak terlalu panjang

                // Data lain font normal ukuran 8
                $pdf->SetFont('Arial', '', 7);

                // ID Santri
                $pdf->SetXY($x + $p_x, $y + $p_y + $line_spacing * 1);
                $pdf->Cell($text_width, 3, 'ID Santri : ' . $data['id_santri'], 0, 1);

                // Jenis Kelamin
                $pdf->SetXY($x + $p_x, $y + $p_y + $line_spacing * 2);
                $pdf->Cell($text_width, 3, 'JK : ' . $data['jenis_kelamin'], 0, 1);

                // TTL
                $pdf->SetXY($x + $p_x, $y + $p_y + $line_spacing * 3);
                $pdf->Cell($text_width, 3, 'TTL : ' . $data['ttl'], 0, 1);

                // Alamat (pakai MultiCell karena bisa panjang)
                $pdf->SetXY($x + $p_x, $y + $p_y + $line_spacing * 4);
                $pdf->MultiCell($text_width, 3, 'Alamat : ' . $data['alamat'], 0, 'L');

                // Tahun Masuk (posisinya harus disesuaikan agar tidak tabrakan dengan multiline alamat)
                // Hitung posisi Y setelah MultiCell alamat:
                $alamat_lines = ceil($pdf->GetStringWidth($data['alamat']) / $text_width);
                $pos_thn_masuk_y = $pdf->GetY() + 1; // beri jarak sedikit

                $pdf->SetXY($x + $p_x, $pos_thn_masuk_y);
                $pdf->Cell($text_width, 3, 'Thn Masuk : ' . $data['tahun_masuk'], 0, 1);



    // Barcode (posisi di bawah data, tengah kanan)
    $barcode_path = 'assets/barcode/' . $data['id_santri'] . '.png';
    if (!file_exists($barcode_path)) {
        $barcodeData = $generator->getBarcode($data['id_santri'], $generator::TYPE_CODE_128);
        file_put_contents($barcode_path, $barcodeData);
    }
    $pdf->Image($barcode_path, $x + 52, $y + 43, 27, 8); // posisi & ukuran barcode

    $col++;
    if ($col >= 2) {
        $col = 0;
        $row++;
    }
}

$pdf->Output();
