<!DOCTYPE html>
<html>
<head>
    <title>Bukti Pengambilan Tunai</title>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            width: 90mm;
            height: auto;
            margin: 1mm;
            padding: 2mm;
            font-size: 13px;
            color: #000;
            line-height: 1.3;
        }
        .header {
            text-align: center;
            margin-bottom: 5px;
            border-bottom: 1px dashed #000;
        }
        .title {
            font-size: 16px;
            font-weight: bold;
        }
        .subtitle {
            font-size: 12px;
        }
        .detail {
            margin: 4px 0;
            display: flex;
            justify-content: space-between;
        }
        .amount {
            text-align: center;
            margin: 8px 0;
            font-size: 14px;
            font-weight: bold;
            background: #eee;
            padding: 5px;
        }
        .signature {
            margin-top: 25px;
            font-size: 12px;
            text-align: center;
        }
        .signature .label {
            margin-bottom: 50px;
        }
        .signature .line {
            border-top: 1px dashed #000;
            width: 60%;
            margin: 0 auto;
            margin-top: 40px;
        }
        .footer {
            text-align: center;
            margin-top: 15px;
            font-size: 10px;
            color: #000;
        }
    </style>
</head>
<body>

<?php
include "../../config/conn.php";
include "../../config/rupiah.php";

$institution = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM pengaturan WHERE id_pengaturan='1'"));
$transaction = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM transaksi_ewallet WHERE id_transaksi='$_GET[id_tran]'"));
$student = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM santri WHERE id_santri='$transaction[rekening]'"));
$admin = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM pegawai WHERE id_pegawai='$transaction[user_id]'"));
?>

<div class="header">
    <div class="title">BUKTI PENGAMBILAN TUNAI</div>
    <div class="subtitle">Informasi : <?= $institution['telephone'] ?></div>
    <div class="subtitle" style="margin-top: 4px;"></div>
</div>

<div class="detail"><span>Tanggal : </span><span><?= date('d-M-Y', strtotime($transaction['tgl_transaksi'])) ?></span></div>
<div class="detail"><span>No. Transaksi : </span><span><?= $transaction['id_transaksi'] ?></span></div>

<div class="detail"><span>Nama Santri : </span><span>(<?= $student['id_santri'] ?>) <?= $student['nama'] ?></span></div>

<div class="amount">
    Jumlah Diambil : Rp <?= rupiah($transaction['kredit']) ?>
</div>

<div class="detail"><span>Keterangan : </span><span><?= $transaction['keterangan'] ?></span></div>
<div class="detail"><span>Petugas : </span><span><?= $admin['nama'] ?></span></div>

<div class="signature">
    <div class="label">Tanda Tangan Penerima</div>
    <div class="line"></div>
</div>

<div class="footer">
    • Dicetak : <?= date('d/M/Y') ?>
</div>

<script>
    window.print();
    setTimeout(window.close, 300);
</script>
</body>
</html>
