<!DOCTYPE html>
<html>
<head>
    <title>Bukti Uang Saku</title>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: Arial, sans-serif;
            width: 90mm;
            margin: 3mm auto;
            padding: 0;
            font-size: 13px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 0px;
            padding-bottom: 0px;
        }
        .title {
            font-size: 18px;
            font-weight: bold;
            margin: 5px 0;
        }
        .subtitle {
            font-size: 14px;
            margin-bottom: 10px;
        }
        .info-box {
            margin: 8px 0;
            padding: 5px 0;
        }
        .divider {
            border-top: 1px dashed #000;
            margin: 8px 0;
        }
        .label {
            font-weight: bold;
            display: inline-block;
            width: 25mm;
        }
        .amount {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            margin: 10px 0;
            padding: 5px;
            background: #f5f5f5;
        }
        .footer {
            font-size: 11px;
            text-align: center;
            margin-top: 10px;
        }
    </style>
</head>
<body>

<?php
include "../../config/conn.php";
include "../../config/rupiah.php";

// Get institution data
$hp = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM pengaturan WHERE id_pengaturan='1'"));

// Get transaction data
$transaction = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM transaksi_ewallet WHERE id_transaksi='$_GET[id_tran]'"));
$student = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM santri WHERE id_santri='$transaction[rekening]'"));
$admin = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM pegawai WHERE id_pegawai='$transaction[user_id]'"));
?>

<div class="header">
    <div class="title">PONDOK TAHFIDZ MODERN AL-IMAM</div>
    <div class="subtitle">Desa Tiru Kidul, Kec. Gurah, Kab. Kediri</div>
    <div>HP: <?php echo $hp['telephone']; ?></div>
    <div class="title">UANG SAKU</div>
</div>

<div class="divider"></div>

<div class="info-box">
    <div><span class="label">Tanggal</span>: <?php echo date('d-M-Y', strtotime($transaction['tgl_transaksi'])); ?></div>
    <div><span class="label">ID Transaksi</span>: <?php echo $transaction['id_transaksi']; ?></div>
</div>

<div class="divider"></div>

<div class="info-box">
    <div><span class="label">ID Santri</span>: <?php echo $student['id_santri']; ?></div>
    <div><span class="label">Nama</span>: <?php echo $student['nama']; ?></div>
</div>

<div class="divider"></div>

<div class="amount">
    JUMLAH UANG SAKU<br>
    Rp <?php echo rupiah($transaction['debit']); ?>
</div>

<div class="info-box">
    <div><span class="label">Keterangan</span>: <?php echo $transaction['keterangan']; ?></div>
</div>

<div class="divider"></div>

<div class="footer">
    <div>User: <?php echo $admin['nama']; ?></div>
    <div>Cetak: <?php echo date('d/m/y H:i'); ?></div>
</div>

<script>
    window.print();
    setTimeout(window.close, 500);
</script>

</body>
</html>