<html>
<?php
include "../../config/conn.php";
include "../../config/rupiah.php";

$hp = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM pengaturan WHERE id_pengaturan=1"));
$transaksi = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM transaksi WHERE id_transaksi='$_GET[id_tran]'"));

if (in_array($transaksi['id_jenis'], ['11', '12', '18'])) {
    $santri = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM santri_rt WHERE id_santri='{$transaksi['id_santri']}'"));
    $kelas = mysqli_fetch_array(mysqli_query($conn, "SELECT nama_jenis FROM jenis_rt WHERE id='{$santri['jenis_rt']}'"));
} else {
    $santri = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM santri WHERE id_santri='{$transaksi['id_santri']}'"));
}

$bulan = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM bulan WHERE id_bulan='{$transaksi['spp_bulan']}'"));
$admin = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM pegawai WHERE id_pegawai='{$transaksi['id_pegawai']}'"));
$jenis = mysqli_fetch_array(mysqli_query($conn, "SELECT * FROM jenis_transaksi WHERE id_jenis='{$transaksi['id_jenis']}'"));
$rp = rupiah($transaksi['debit']);
?>

<head>
    <title>Struk Pembayaran</title>
    <style>
        body {
            font-family: Verdana, sans-serif;
            width: 90mm;
            margin: 0;
            padding: 4mm;
            font-size: 13px;
            line-height: 1.4;
            color: #000;
        }
        .header, .footer, .signature {
            text-align: center;
        }
        .header {
            border-bottom: 1px dashed #333;
            margin-bottom: 8px;
            padding-bottom: 6px;
        }
        .title {
            font-size: 16px;
            font-weight: bold;
        }
        .subtitle {
            font-size: 12px;
        }
        .info-box {
            margin: 6px 0;
        }
        .bold {
            font-weight: bold;
        }
        .divider {
            border-top: 1px dashed #aaa;
            margin: 8px 0;
        }
        .amount {
            text-align: center;
            font-size: 13px;
            font-weight: bold;
            background: #f1f1f1;
            padding: 6px;
            border-radius: 4px;
        }
        .signature {
            margin-top: 30px;
            font-size: 12px;
        }
    </style>
</head>

<body>
    <div class="header">
        <div class="title">PONDOK TAHFIDZ MODERN AL-IMAM</div>
        <div class="subtitle">Desa Tiru Kidul, Kec. Gurah, Kab. Kediri</div>
        <div class="subtitle">Telp: <?= $hp['telephone']; ?></div>
    </div>

    <div class="info-box">
        <div><span class="bold">Tanggal:</span> <?= date('d-M-Y', strtotime($transaksi['tanggal'])); ?></div>
        <div><span class="bold">No. Transaksi:</span> <?= $transaksi['id_transaksi']; ?></div>
    </div>

    <div class="info-box">
        <div><span class="bold">ID Santri:</span> <?= $transaksi['id_santri']; ?></div>
        <div><span class="bold">Nama:</span> <?= $santri['nama']; ?></div>
    </div>

    <div class="divider"></div>

    <div><span class="bold">Jenis Pembayaran :</span>
    
        <?php
        switch ($transaksi['id_jenis']) {
            case '5':
                echo "$jenis[nama_jenis] <br>Periode: $bulan[nama_bulan] $transaksi[spp_tahun]";
                break;
            case '14':
                echo "Daftar Awal Masuk";
                break;
            case '17':
                echo "Daftar Ulang <br>Tahun: $transaksi[dut_tahun]";
                break;
            case '18':
                echo "Dana Awal Masuk RT Pagi";
                break;
            case '11':
            case '12':
                echo "$jenis[nama_jenis] | $kelas[nama_jenis] <br>Periode: $bulan[nama_bulan] $transaksi[spp_tahun]";
                break;
            default:
                echo $jenis['nama_jenis'];
        }
        ?>
    </div>

    <div class="divider"></div>

    <div class="amount">
        TOTAL PEMBAYARAN<br>Rp <?= $rp; ?>
    </div>

    <div class="divider"></div>

    <div><span class="bold">Keterangan:</span> <?= $transaksi['keterangan']; ?></div>

    <div class="footer">
        <div>Diterima oleh: <?= $admin['nama']; ?></div>
        <div>Cetak: <?= date('d/m/Y'); ?></div>
        <div> </div>
    </div>

    <div class="signature">
        <div>__________________________</div>
        <div><em>Tanda Tangan Penerima</em></div>
    </div>

    <script>
        window.print();
        setTimeout(() => window.close(), 500);
    </script>
</body>
</html>
