
<?php
function kirimPesanTelegram($pesan,$tujuan)
{
    // [1] Muat library MadelineProto jika belum dimuat
    if (!class_exists(\danog\MadelineProto\API::class)) {
        require_once __DIR__ . '/madeline81.phar';
    }

    // [2] Akses koneksi database
    global $con;

    // [3] Ambil data koneksi Telegram dari database
    $query = $con->query("SELECT * FROM tb_koneksi_tg ORDER BY id DESC LIMIT 1");
    $tg = $query->fetch_assoc();

    if (!$tg) {
        error_log("❌ API ID dan Hash belum tersedia di tabel tb_koneksi_tg.");
        return;
    }

    try {
        // [4] Lokasi penyimpanan session file
        $session_file = __DIR__ . '/session.madeline';

        // [5] Siapkan pengaturan aplikasi Telegram
        $settings = new \danog\MadelineProto\Settings;
        $settings->setAppInfo(
            (new \danog\MadelineProto\Settings\AppInfo)
                ->setApiId((int)$tg['api_id'])        // Konversi ke integer
                ->setApiHash($tg['api_hash'])
        );
        $settings->setLogger(
            (new \danog\MadelineProto\Settings\Logger)
                ->setMaxSize(10 * 1024) // 10 KB
        );

        // [6] Mulai MadelineProto dengan pengaturan dan session
        $MadelineProto = new \danog\MadelineProto\API($session_file, $settings);
        $MadelineProto->start();

        // [7] Kirim pesan ke username tujuan (harus sudah pernah dikontak)
         $MadelineProto->messages->sendMessage([
            'peer' => $tujuan,
            'message' => $pesan
        ]);

    } catch (\danog\MadelineProto\Exception | \Exception $e) {
        error_log("❌ Gagal mengirim pesan Telegram: " . $e->getMessage());
    }
}


function namakelas($id_mkelas)
{

    global $con;
    // Ambil data kelas
        $sql_kelas = "SELECT * FROM tb_mkelas WHERE id_mkelas = '$id_mkelas'";
        $result_kelas = mysqli_query($con, $sql_kelas);
        $kelas = mysqli_fetch_assoc($result_kelas);
        $nama_kelas = $kelas['nama_kelas'];
   
        return $nama_kelas;
}

?>