<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json');
include '../config/db.php';
include '../assets/libs/function.php';

// Ambil data RFID
$rfid_uid = isset($_POST['rfid_number']) ? trim($_POST['rfid_number']) : '';

if (empty($rfid_uid)) {
    echo json_encode(['status' => 'error', 'pesan' => 'ID RFID kosong']);
    exit;
}

// Ambil data siswa
$sql_siswa = "SELECT * FROM tb_siswa WHERE rfid = '$rfid_uid'";
$result_siswa = mysqli_query($con, $sql_siswa);

if (mysqli_num_rows($result_siswa) === 0) {
    echo json_encode(['status' => 'error', 'pesan' => 'Kartu tidak dikenali']);
    exit;
}

$siswa = mysqli_fetch_assoc($result_siswa);
$nis = $siswa['nis'];
$nama = $siswa['nama_siswa'];
$kelas = namakelas($siswa['id_mkelas']);
$foto = !empty($siswa['foto']) ? $siswa['foto'] : null;
$chatId = !empty($siswa['id_telegram']) ? $siswa['id_telegram'] : null;

$tanggal = date('Y-m-d');
$jam_sekarang = date('H:i:s');

// Ambil pengaturan jam absen
$sql_pengaturan = "SELECT * FROM tb_absensi_umum_pengaturan LIMIT 1";
$result_pengaturan = mysqli_query($con, $sql_pengaturan);
$pengaturan = mysqli_fetch_assoc($result_pengaturan);

if (!$pengaturan) {
    echo json_encode(['status' => 'error', 'pesan' => 'Pengaturan absensi belum tersedia']);
    exit;
}

$jam_masuk = $pengaturan['jam_masuk'];
$batas_terlambat = $pengaturan['batas_terlambat'];
$jam_pulang = date('H:i:s', strtotime($pengaturan['jam_pulang']));

// Cek absensi hari ini
$sql_cek = "SELECT * FROM tb_absensi_umum WHERE nis = '$nis' AND tanggal = '$tanggal'";
$result_cek = mysqli_query($con, $sql_cek);
$cek_absen = mysqli_fetch_assoc($result_cek);

// Default respons
$response = [
    'status' => 'error',
    'pesan' => '',
];

$telegramMessage = null;

// Proses logika absensi
if ($cek_absen) {
    if (!empty($cek_absen['jam_masuk']) && empty($cek_absen['jam_pulang'])) {
        if ($jam_sekarang < $jam_pulang) {
            $response['pesan'] = 'Belum waktunya absen pulang';
        } else {
            $status_pulang = ($jam_sekarang <= $jam_pulang) ? '1' : '0';
            $sql_pulang = "UPDATE tb_absensi_umum SET jam_pulang = '$jam_sekarang', status_pulang = '$status_pulang' WHERE nis = '$nis' AND tanggal = '$tanggal'";
            mysqli_query($con, $sql_pulang);

            $response = [
                'status' => 'success',
                'pesan' => 'Absen Pulang berhasil!',
                'nama' => $nama,
                'nis' => $nis,
                'kelas' => $kelas,
                'foto' => $foto,
                'waktu' => date('d M Y H:i:s'),
            ];

            $telegramMessage = "🕒  **Absen Pulang** \nTanggal : $tanggal \n👤 $nama ($nis)\n🏫 Kelas: $kelas\n⏰ Jam: $jam_sekarang\n📌 Status: " . ($status_pulang === '1' ? 'Tepat Waktu' : 'Terlambat');
        }
    } elseif (!empty($cek_absen['jam_masuk']) && !empty($cek_absen['jam_pulang'])) {
        $response['pesan'] = 'Anda sudah absen datang dan pulang hari ini';
    } else {
        $response['pesan'] = 'Data absensi tidak valid. Hubungi admin.';
    }
} else {
    if ($jam_sekarang < $jam_masuk) {
        $response['pesan'] = 'Belum waktunya absen masuk';
    } else {
        $status_masuk = ($jam_sekarang <= $batas_terlambat) ? '1' : '0';
        $sql_masuk = "INSERT INTO tb_absensi_umum (nis, tanggal, jam_masuk, status_masuk) VALUES ('$nis', '$tanggal', '$jam_sekarang', '$status_masuk')";
        mysqli_query($con, $sql_masuk);

        $response = [
            'status' => 'success',
            'pesan' => 'Absen Masuk berhasil!',
            'nama' => $nama,
            'nis' => $nis,
            'kelas' => $kelas,
            'foto' => $foto,
            'waktu' => date('d M Y H:i:s'),
        ];

        $telegramMessage = "🕒  **Datang Sekolah** \nTanggal : $tanggal \n👤 $nama ($nis)\n🏫 Kelas: $kelas\n⏰ Jam: $jam_sekarang\n📌 Status: " . ($status_masuk === '1' ? 'Tepat Waktu' : 'Terlambat');
    }
}

// Kirim JSON ke browser secepatnya
echo json_encode($response);

// Optimalkan: segera tutup koneksi HTTP dengan client
if (function_exists('fastcgi_finish_request')) {
    fastcgi_finish_request();
}
$tujuan = $chatId;
$pesan = $telegramMessage;
// Kirim Telegram secara async (jika berhasil absen)
if (!empty($telegramMessage)) {
    // kirimTelegramAsync($botToken, $chatId, $telegramMessage);
    
   kirimPesanTelegram($pesan,$tujuan);
}

?>
