<div class="panel-header bg-primary-gradient">
    <div class="page-inner py-5">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
            <div>
                <h5 class="text-white op-7 mb-2">Selamat Datang, <b class="text-warning"><?=$data['nama_lengkap']; ?></b> | Absensi RFID</h5>
            </div>
            <div class="ml-md-auto py-2 py-md-0">
                <a href="#" class="btn btn-white btn-border btn-round mr-2">Kembali</a>
                <a href="?page=rekap-absenumum" class="btn btn-secondary btn-round">Riwayat Aabsen</a>
            </div> 
        </div>
    </div>
</div>

<div class="page-inner mt--5">
    <div class="row">
        <!-- Kolom Kiri - Form Absen RFID -->
        <div class="col-md-8">
            <div class="card full-height">
                <div class="card-header">
                    <h4 class="card-title"><i class="fas fa-id-card mr-2"></i> Absensi Datang dan Pulang</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <div class="rfid-scanner-area mb-4">
                                <div class="scanner-animation">
                                    <div class="scanner-light"></div>
                                    <i class="fas fa-rfid fa-5x text-primary mb-3"></i>
                                    <h3 class="text-muted">Tempelkan Kartu RFID Anda</h3>
                                </div>
                                
                                <form id="rfidForm">
                                    <div class="form-group">
                                        <input type="text" 
                                               class="form-control form-control-lg text-center" 
                                               id="rfidInput" 
                                               name="rfid_number" 
                                               placeholder="ID RFID akan muncul otomatis" 
                                               autocomplete="off"
                                               autofocus
                                               required>
                                    </div>
                                    <button type="submit" class="btn btn-primary btn-lg btn-round" id="submitBtn" disabled>
                                        <i class="fas fa-check-circle mr-2"></i>Proses Absensi
                                    </button>
                                </form>
                                </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                <h4><i class="fas fa-info-circle mr-2"></i>Petunjuk Penggunaan:</h4>
                                <ol>
                                    <li>Tempelkan kartu RFID Anda pada reader</li>
                                    <li>ID RFID akan terbaca otomatis</li>
                                    <li>Sistem akan menampilkan data Anda</li>
                                    <li>Klik tombol "Proses Absensi" untuk menyimpan</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Kolom Kanan - Informasi Siswa -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><i class="fas fa-user-graduate mr-2"></i> Informasi Siswa</h4>
                </div>
                <div class="card-body">
                    <div class="text-center mb-4" id="studentPhotoContainer">
                        <img src="../assets/img/admin.png" 
                             class="rounded-circle img-fluid" 
                             width="150" 
                             id="studentPhoto"
                             alt="Foto Siswa">
                    </div>
                    
                    <div class="student-info" id="studentInfo">
                        <div class="text-center">
                            <h4 class="text-muted">Data akan muncul setelah scan RFID</h4>
                            <p class="text-muted">Tempelkan kartu RFID Anda pada reader</p>
                        </div>
                    </div>
                    
                    <div class="attendance-result mt-4" id="attendanceResult"></div>
                </div>
            </div>
            
            <!-- Statistik Cepat -->
            <div class="card card-stats card-round mt-4">
                <div class="card-body">
                    <div class="row">
                        <div class="col-5">
                            <div class="icon-big text-center">
                                <i class="flaticon-success text-success"></i>
                            </div>
                        </div>
                        <div class="col-7 col-stats">
                            <div class="numbers">
                                <p class="card-category">Hadir Hari Ini</p>
                                <h4 class="card-title"><?php echo $hadirHariIni; ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .rfid-scanner-area {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 30px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    
    .scanner-animation {
        position: relative;
        margin-bottom: 30px;
        padding: 20px;
    }
    
    .scanner-light {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 3px;
        background: linear-gradient(90deg, rgba(0,0,0,0) 0%, #1a73e8 50%, rgba(0,0,0,0) 100%);
        animation: scan 2s infinite linear;
        opacity: 0.7;
    }
    
    @keyframes scan {
        0% { top: 0; }
        100% { top: 100%; }
    }
    
    #rfidInput {
        font-size: 1.5rem;
        letter-spacing: 2px;
        border: 2px dashed #ddd;
        background: #fff;
    }
    
    .student-info {
        transition: all 0.3s ease;
    }
    
    .attendance-success {
        background: #e8f5e9;
        border-left: 4px solid #4caf50;
        padding: 15px;
        border-radius: 4px;
    }
    
    .attendance-error {
        background: #ffebee;
        border-left: 4px solid #f44336;
        padding: 15px;
        border-radius: 4px;
    }
</style>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
    $('#rfidInput').focus();

    $('#rfidInput').on('input', function () {
        if ($(this).val().length > 0) {
            $('#submitBtn').prop('disabled', false);
        } else {
            $('#submitBtn').prop('disabled', true);
            resetStudentInfo();
        }
    });

    $('#rfidForm').on('submit', function (e) {
        e.preventDefault();
        let rfid = $('#rfidInput').val().trim();

        if (rfid === '') return;

        $('#submitBtn').html('<i class="fas fa-spinner fa-spin mr-2"></i>Memproses...');
        $('#submitBtn').prop('disabled', true);

        $.ajax({
            url: '../absenumum/proses_absen.php',
            method: 'POST',
            data: { rfid_number: rfid },
            dataType: 'json',
            success: function (response) {
                if (response.status === 'success') {
                    let fotoPath = response.foto ? `../assets/img/user/${response.foto}` : '../assets/img/admin.png';
                    $('#studentPhoto').attr('src', fotoPath);
                    $('#studentInfo').html(`
                        <h3 class="text-primary">${response.nama}</h3>
                        <p><strong>NIS:</strong> ${response.nis}</p>
                        <p><strong>Kelas:</strong> ${response.kelas}</p>
                        <p><strong>Status:</strong> <span class="badge badge-success">Aktif</span></p>
                    `);
                    $('#attendanceResult').html(`
                        <div class="attendance-success">
                            <h4><i class="fas fa-check-circle text-success mr-2"></i>${response.pesan}</h4>
                            <p>${response.nama} (${response.kelas}) tercatat pada ${response.waktu}</p>
                        </div>
                    `);
                } else {
                    resetStudentInfo();
                    $('#attendanceResult').html(`
                        <div class="attendance-error">
                            <h4><i class="fas fa-times-circle text-danger mr-2"></i>Gagal</h4>
                            <p>${response.pesan}</p>
                        </div>
                    `);
                }

                $('#submitBtn').html('<i class="fas fa-check-circle mr-2"></i>Proses Absensi');
                $('#submitBtn').prop('disabled', false);
                $('#rfidInput').val('').focus();

                setTimeout(() => { $('#attendanceResult').html(''); }, 5000);
            },
            error: function () {
                alert('Terjadi kesalahan saat mengirim data.');
                $('#submitBtn').html('<i class="fas fa-check-circle mr-2"></i>Proses Absensi');
                $('#submitBtn').prop('disabled', false);
            }
        });
    });

    function resetStudentInfo() {
        $('#studentPhoto').attr('src', '../assets/img/admin.png');
        $('#studentInfo').html(`
            <div class="text-center">
                <h4 class="text-muted">Data akan muncul setelah scan RFID</h4>
                <p class="text-muted">Tempelkan kartu RFID Anda pada reader</p>
            </div>
        `);
    }
});
</script>
